package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

import java.security.Key;

public class OAuth2ResourceServerConfig implements OAuth2TokenConfig {

    @JsonProperty
    private String publicKeyPath;

    public String getPublicKeyPath() {
        return publicKeyPath;
    }

    public void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws Exception {
        if (this.publicKeyPath == null)
            throw new Exception("SigningKeyPath must be set");

        return KeyReaderRSA.getPublicKey(this.publicKeyPath);
    }
}
