/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.net.URI;
import net.leanix.dropkit.etcd.EtcdClient;
import net.leanix.dropkit.etcd.EtcdClientException;
import net.leanix.dropkit.etcd.EtcdResult;
import net.leanix.dropkit.util.DeploymentColor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtil {
    static String ROOT_VHOSTS = "/vhosts/";
    public static final String VIRTUAL_HOST = "VIRTUAL_HOST";
    public static final String CONTAINER_COLOR = "CONTAINER_COLOR";
    public static final String ETCD_SERVER = "ETCD_SERVER";
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentUtil.class);
    private final DeploymentColor containerColor;
    final URI etcdUri;

    public DeploymentUtil() {
        String color = this.getEnvironmentVariable(CONTAINER_COLOR);
        this.containerColor = DeploymentColor.fromString(color);
        LOG.debug("Detected assgigned deployment color '{}' to this container.", (Object)this.containerColor);
        String etcdServer = this.getEnvironmentVariable(ETCD_SERVER);
        if (StringUtils.isEmpty((CharSequence)etcdServer)) {
            LOG.debug("No etcd server configuration detected. Is this container running in an on premise environment? ETCD configuration will be skipped.");
            this.etcdUri = null;
        } else {
            this.etcdUri = URI.create(String.format("http://%s", etcdServer));
        }
    }

    public DeploymentColor getContainerColor() {
        return this.containerColor;
    }

    public boolean isInstanceCurrentlyActive() {
        if (this.containerColor == null) {
            LOG.warn("Can not detect container color and return: NO - this container is not currently active.");
            return false;
        }
        if (this.containerColor == DeploymentColor.WHITE) {
            return true;
        }
        if (this.etcdUri == null) {
            if (this.containerColor != DeploymentColor.WHITE) {
                LOG.warn("Althought the container color '{}' is specified, no environment variable '{}' exists to specify the etcd configuration.", (Object)this.containerColor, (Object)ETCD_SERVER);
            }
            return true;
        }
        String virtualHost = this.getEnvironmentVariable(VIRTUAL_HOST);
        if (StringUtils.isEmpty((CharSequence)virtualHost)) {
            virtualHost = "local-svc.leanix.net";
            LOG.warn("Environment variable '{}' not found. Using '{}' as default.", (Object)VIRTUAL_HOST, (Object)virtualHost);
        }
        String key = ROOT_VHOSTS + virtualHost.trim() + "/deploy_current";
        EtcdClient client = new EtcdClient(this.etcdUri);
        try {
            EtcdResult result = client.get(key);
            if (result != null && !result.isError()) {
                String currentColor = result.getNode().getValue();
                LOG.debug("Read current deployment color '{}' from etcd. This container has color {}. (URL: {}, key: '{}')", new Object[]{currentColor, this.containerColor, this.etcdUri, key});
                return this.containerColor.toString().equalsIgnoreCase(currentColor);
            }
        }
        catch (EtcdClientException e) {
            LOG.warn("Can not connect to etcd server! (URL: " + this.etcdUri + ")", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Internal error: Can not connect to etcd server! (URL: " + this.etcdUri + ")", (Throwable)e);
        }
        return false;
    }

    private String getEnvironmentVariable(String varName) {
        String env = System.getenv(varName);
        if (env == null) {
            LOG.debug("Environment varible '{}' not found in Sytem.env(). Try to read from system.properties.", (Object)varName);
            return System.getProperty(varName);
        }
        return env;
    }
}

