/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import net.leanix.dropkit.oauth.models.Principal;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;
import net.leanix.dropkit.oauth.token.OAuth2TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Authenticator
implements Authenticator<String, Principal> {
    private final Logger logger = LoggerFactory.getLogger(OAuth2Authenticator.class);
    private final OAuth2TokenParser parser;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public OAuth2Authenticator(OAuth2TokenConfig config) throws Exception {
        this.parser = new OAuth2TokenParser(config);
    }

    public Optional<Principal> authenticate(String accessToken) throws AuthenticationException {
        try {
            OAuth2Token token = this.parser.parse(accessToken);
            return Optional.fromNullable((Object)token.getPrincipal());
        }
        catch (Throwable ex) {
            this.logger.error("Unable to verify token " + accessToken.substring(0, 10) + "..., reason: " + ex.getMessage(), ex);
            throw new AuthenticationException("Unable to authenticate token.", ex);
        }
    }

    static {
        mapper.disableDefaultTyping();
    }
}

