/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.io.IOException;
import net.leanix.dropkit.oauth.AuthenticatedUser;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import net.leanix.dropkit.oauth.VerifyTokenResponse;
import org.slf4j.Logger;

public class OAuth2Authenticator
implements Authenticator<String, AuthenticatedUser> {
    private static final String BEARER = "bearer";
    private final String tokenVerificationUrl;
    private final String authorizationValue;
    private final Logger logger;
    private final Client client = Client.create();
    private static final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public OAuth2Authenticator(OAuth2ClientConfig configuration, Logger logger) {
        System.setProperty("jsse.enableSNIExtension", "false");
        this.tokenVerificationUrl = configuration.getVerificationUrl();
        this.authorizationValue = "Basic ".concat(new String(Base64.encode((byte[])configuration.getClientId().concat(":").concat(configuration.getClientSecret()).getBytes())));
        this.logger = logger;
    }

    public Optional<AuthenticatedUser> authenticate(String accessToken) throws AuthenticationException {
        return Optional.fromNullable((Object)this.verify(accessToken));
    }

    private boolean isValidResponse(VerifyTokenResponse tokenResponse) {
        return tokenResponse != null && tokenResponse.getPrincipal() != null && tokenResponse.getError() == null;
    }

    private AuthenticatedUser verify(String accessToken) throws AuthenticationException {
        try {
            this.logger.debug("Verifying access token " + accessToken + " against " + this.tokenVerificationUrl);
            String json = (String)((WebResource.Builder)this.client.resource(String.format(this.tokenVerificationUrl.concat("?access_token=%s"), accessToken)).header("Authorization", (Object)this.authorizationValue).accept(new String[]{"application/json"})).get(String.class);
            VerifyTokenResponse response = (VerifyTokenResponse)mapper.readValue(json, VerifyTokenResponse.class);
            if (this.isValidResponse(response)) {
                return response.getPrincipal();
            }
            return null;
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == ClientResponse.Status.GONE.getStatusCode()) {
                this.logger.warn("Access token {} is not valid any more: {}", (Object)accessToken, (Object)ex.getMessage());
                return null;
            }
            this.logger.error("Unable to verify token " + accessToken + ": " + ex.getMessage(), (Throwable)ex);
            throw new AuthenticationException("Access token verification failed: " + ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error("Unable to parse verification response for token " + accessToken + ": " + ex.getMessage(), (Throwable)ex);
            throw new AuthenticationException("Unable to parse verification response: " + ex.getMessage(), (Throwable)ex);
        }
        catch (Throwable ex) {
            this.logger.error("Unable to verify token " + accessToken + ", unknown reason: " + ex.getMessage(), ex);
            throw new AuthenticationException("Unable to perform authentication, unknown reason.", ex);
        }
    }

    static {
        mapper.disableDefaultTyping();
    }
}

