/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.google.inject.Inject;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import net.leanix.dropkit.amqp.ConnectionHolder;
import net.leanix.dropkit.amqp.ConsumerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueProducer {
    private final Logger log = LoggerFactory.getLogger(QueueProducer.class);
    private final Charset utf8 = Charset.forName("UTF-8");
    private final ConnectionHolder connectionHolder;
    private Channel channel;
    private final ConsumerRegistry registry;

    @Inject
    public QueueProducer(ConnectionHolder connectionHolder, ConsumerRegistry consumerRegistry) {
        this.connectionHolder = connectionHolder;
        this.registry = consumerRegistry;
    }

    public UUID submit(String jsonString, String queueName) throws IOException {
        byte[] msgContent = jsonString.getBytes(this.utf8);
        this.registry.consumerPresto(queueName);
        return this.performPublish(queueName, msgContent);
    }

    private UUID performPublish(String queueName, byte[] msgContent) throws IOException {
        if (this.channel == null || !this.channel.isOpen()) {
            this.log.info("creating a channel to AMQP server for publishing");
            this.channel = this.connectionHolder.createNewChannel();
        }
        try {
            Map<String, Long> args = Collections.singletonMap("x-expires", 120000L);
            this.channel.queueDeclare(queueName, true, false, false, args);
            UUID messageId = UUID.randomUUID();
            this.log.info("publishing message {} to queue {}", (Object)messageId, (Object)queueName);
            AMQP.BasicProperties.Builder bldr = new AMQP.BasicProperties.Builder();
            bldr.messageId(messageId.toString());
            bldr.contentEncoding(this.utf8.name());
            bldr.contentType("application/json");
            bldr.deliveryMode(Integer.valueOf(2));
            this.channel.basicPublish("", queueName, false, bldr.build(), msgContent);
            return messageId;
        }
        catch (ShutdownSignalException e) {
            this.log.info("{} was shut down unexpectedly", (Object)(e.isHardError() ? "Connection" : "Channel"));
            this.channel = null;
            if (e.isHardError()) {
                this.connectionHolder.closeConnection();
            }
            return null;
        }
    }
}

