/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.codahale.metrics.health.HealthCheck;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPHealthCheck
extends HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPHealthCheck.class);
    private final ConnectionFactory connectionFactory;

    public AMQPHealthCheck(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() throws Exception {
        Connection conn = null;
        try {
            conn = this.connectionFactory.newConnection();
            if (conn.isOpen()) {
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
            HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"AMQP connection is closed.");
            return result;
        }
        catch (IOException e) {
            HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Cannot open AMQP connection. " + e.getMessage()));
            return result;
        }
        finally {
            if (conn != null) {
                try {
                    LOG.info("Closing AMQP connection.");
                    conn.close();
                }
                catch (IOException e) {
                    conn = null;
                    LOG.info("Error closing AMQP connection.");
                }
            }
        }
    }
}

