/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import net.leanix.dropkit.amqp.AMQPConfiguration;
import net.leanix.dropkit.amqp.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueProducer
extends Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(QueueProducer.class);
    private static final String encoding = "UTF-8";

    public QueueProducer(AMQPConfiguration config, ConnectionFactory connectionFactory) throws IOException {
        super(config, connectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID sendMessage(String message, String queue) throws IOException {
        byte[] bytes = message.getBytes(encoding);
        AMQP.BasicProperties.Builder target = new AMQP.BasicProperties.Builder();
        UUID messageId = UUID.randomUUID();
        target.messageId(messageId.toString());
        target.contentType("application/json");
        target.contentEncoding(encoding);
        byte[] correlationId = UUID.randomUUID().toString().getBytes(encoding);
        if (correlationId != null && correlationId.length > 0) {
            try {
                target.correlationId(new String(correlationId, encoding));
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        try {
            this.channel.basicPublish(this.configuration.getExchange(), queue, false, false, target.build(), bytes);
        }
        catch (Exception ex) {
            LOG.error("Failed to publish the event " + message, (Throwable)ex);
        }
        finally {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        LOG.info("Publishing message on exchange [" + this.configuration.getExchange() + "], routingKey = [" + this.configuration.getQueue() + "]");
        return messageId;
    }

    public UUID sendMessage(String message) throws IOException {
        return this.sendMessage(message, this.configuration.getQueue());
    }
}

