/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import net.leanix.dropkit.amqp.AMQPConfiguration;
import net.leanix.dropkit.amqp.DeliveryHandler;
import net.leanix.dropkit.amqp.Endpoint;
import org.joda.time.DateTime;
import org.slf4j.LoggerFactory;

public class QueueConsumer
extends Endpoint
implements Runnable,
Consumer {
    private final DeliveryHandler handler;
    private final String bindingKey;
    private DateTime lastUsage;

    public QueueConsumer(AMQPConfiguration config, ConnectionFactory connectionFactory, DeliveryHandler handler) throws IOException {
        super(config, connectionFactory);
        this.handler = handler;
        this.bindingKey = null;
        this.lastUsage = new DateTime(Integer.MIN_VALUE);
    }

    public QueueConsumer(AMQPConfiguration config, ConnectionFactory factory, DeliveryHandler handler, String bindingKey) throws IOException {
        super(config, factory);
        this.handler = handler;
        this.bindingKey = bindingKey;
        this.lastUsage = new DateTime(Integer.MIN_VALUE);
        this.channel.queueBind(config.getQueue(), config.getExchange(), bindingKey);
        LoggerFactory.getLogger(QueueConsumer.class).info("New QueueConsumer with bindingKey: " + bindingKey + " started.");
    }

    @Override
    public void run() {
        try {
            LoggerFactory.getLogger(QueueConsumer.class).info("QueueConsumer with bindingKey: " + this.bindingKey + " starts to consume in thread " + Thread.currentThread().getName());
            this.channel.basicConsume(this.configuration.getQueue(), true, (Consumer)this);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(QueueConsumer.class).error("QueueConsumer error: ", (Throwable)e);
        }
    }

    public void registerWithChannel() throws IOException {
        this.channel.basicConsume(this.configuration.getQueue(), true, (Consumer)this);
    }

    public void handleConsumeOk(String consumerTag) {
        System.out.println("Consumer " + consumerTag + " registered");
    }

    public void handleDelivery(String consumerTag, Envelope env, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.handler.handleDelivery((BasicProperties)props, body);
    }

    public void handleCancel(String consumerTag) {
    }

    public void handleCancelOk(String consumerTag) {
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException arg1) {
    }

    public String getBindingKey() {
        return this.bindingKey;
    }

    public void setLastUsage(DateTime lastUsage) {
        this.lastUsage = lastUsage;
    }

    public DateTime getLastUsage() {
        return this.lastUsage;
    }
}

