package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.leanix.dropkit.api.DateTimeDeserializer;
import net.leanix.dropkit.api.Link;
import org.joda.time.DateTime;

/**
 * User representation on the side of resource providers.
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ResourceOwner implements Serializable, AuthenticatedUser {

    private String id;
    private String userName;
    private UserRole role;
    private UserStatus status;
    private String email;
    private String firstName;
    private String lastName;
    private DateTime lastLogin;
    private String apiKey;
    private String feedKey;
    private final List<Link> links = new ArrayList<>();
    private Account account;
    private List<WorkspacePermission> permissions;

    public ResourceOwner() {
        this.id = null;
        this.userName = null;
        this.email = null;
        this.firstName = null;
        this.lastName = null;
        this.apiKey = null;
    }

    public String getId() {
        return id;
    }

    @Override
    public String getIdentifier() {
        return (id != null) ? id : "";
    }

    public void setIdentifier(String id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return userName;
    }

    public String getEmail() {
        return email;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastname(String lastname) {
        this.lastName = lastname;
    }

    @JsonSerialize(using = DateTimeSerializer.class)
    @ApiModelProperty(dataType = "dateTime")
    public DateTime getLastLogin() {
        return lastLogin;
    }

    @JsonDeserialize(using = DateTimeDeserializer.class)
    public void setLastLogin(DateTime lastLogin) {
        this.lastLogin = lastLogin;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getFeedKey() {
        return feedKey;
    }

    public void setFeedKey(String feedKey) {
        this.feedKey = feedKey;
    }

    @Override
    public AuthenticatedUserAccount getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @Override
    public List<WorkspacePermission> getPermissions() {
        return permissions;
    }

    @JsonDeserialize(as = ArrayList.class, contentAs = Permission.class)
    public void setPermissions(List<WorkspacePermission> permissions) {
        this.permissions = permissions;
    }

    public List<Link> getLinks() {
        return links;
    }

    public String getDisplayName() {
        return firstName + " " + lastName;
    }

    @Override
    @ApiModelProperty(dataType = "string")
    public UserRole getRole() {
        return role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    @Override
    @ApiModelProperty(dataType = "string")
    public UserStatus getStatus() {
        return status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    @Override
    @JsonIgnore
    public boolean isActive(UserRole role) {
        return getRole() != null && getRole().equals(role)
                && UserStatus.ACTIVE.equals(status);
    }
}
