package net.leanix.dropkit.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The producer endpoint that writes to the queue.
 *
 * @author syntx
 * @link http://syntx.io/getting-started-with-rabbitmq-in-java/
 */
public class QueueProducer extends Endpoint {

    private static final Logger LOG = LoggerFactory.getLogger(QueueProducer.class);
    private static final String encoding = "UTF-8";

    public QueueProducer(AMQPConfiguration config, ConnectionFactory connectionFactory) throws IOException {
        super(config, connectionFactory);
    }

    public UUID sendMessage(String message, String queue) throws IOException {
        byte[] bytes;
        bytes = message.getBytes(encoding);
        AMQP.BasicProperties.Builder target = new AMQP.BasicProperties.Builder();
        UUID messageId = UUID.randomUUID();
        target.messageId(messageId.toString());
        target.contentType("application/json");
        target.contentEncoding(encoding);
        byte[] correlationId = UUID.randomUUID().toString().getBytes(encoding);
        if (correlationId != null && correlationId.length > 0) {
            try {
                target.correlationId(new String(correlationId, encoding));
            } catch (UnsupportedEncodingException ex) {
            }
        }

        try {
            channel.basicPublish(this.configuration.getExchange(), queue, false, false, target.build(), bytes);
        } catch (Exception ex) {
            LOG.error("Failed to publish the event " + message, ex);
        } finally {
            if (channel != null) {
                channel.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        LOG.info("Publishing message on exchange [" + this.configuration.getExchange() + "], routingKey = [" + this.configuration.getQueue() + "]");
        return messageId;

    }
    
    public UUID sendMessage(String message) throws IOException {
        return this.sendMessage(message, this.configuration.getQueue());
    }
}
