package net.leanix.dropkit.amqp;

import java.io.IOException;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

/**
 * Represents a connection with a queue
 *
 * @author syntx
 */
public abstract class Endpoint {

    protected Channel channel;
    protected Connection connection;
    protected AMQPConfiguration configuration;

    /**
     * Pass the queue name and the connection factory.
     *
     * @param configuration
     * @param factory
     * @throws IOException
     */
    public Endpoint(AMQPConfiguration configuration, ConnectionFactory factory) throws IOException {
        //getting a connection
        connection = factory.newConnection();

        //creating a channel
        channel = connection.createChannel();

        this.configuration = configuration;

        //declaring a queue for this channel. If queue does not exist,
        //it will be created on the server.
        channel.queueDeclare(configuration.getQueue(), false, false, false, null);
    }

    /**
     * Close channel and connection. Not necessary as it happens implicitly any
     * way.
     *
     * @throws IOException
     */
    public void close() throws IOException {
        this.channel.close();
        this.connection.close();
    }
}
