package net.leanix.dropkit.amqp;

import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.LoggerFactory;

/**
 *
 * @author alexanderalt
 */
public class AMQPQueueObserver {

    private static final List<QueueConsumer> registeredQueues = new LinkedList();

    public static List<QueueConsumer> getRegisteredQueues() {
        return registeredQueues;
    }

    public static void registerQueueConsumer(QueueConsumer queueConsumer) {
        registeredQueues.add(queueConsumer);
    }

    public static void unregisterQueueConsumer(QueueConsumer queueConsumer) {
        registeredQueues.remove(queueConsumer);
    }

    public static boolean isQueueRegistered(String queue) {
        for (QueueConsumer q : registeredQueues) {
            if (q.getBindingKey().equals(queue)) {
                return true;
            }
        }
        return false;
    }

    public static void setLastUsage(String bindingKey) {
        for (QueueConsumer q : registeredQueues) {
            if (q.getBindingKey().equals(bindingKey)) {
                DateTime now = new DateTime();
                q.setLastUsage(now);
                LoggerFactory.getLogger(AMQPQueueObserver.class).info("LastUsage of Queue with bindingKey " + bindingKey + " set to " + now);
                break;
            }
        }
    }
}
