package net.leanix.dropkit.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.leanix.dropkit.BusinessLogicException;
import net.leanix.dropkit.api.ApiError;

/**
 * A generic entity container for api responses.
 *
 *
 *
 */
@JsonInclude(Include.NON_NULL)
public class BasicResponse {

    protected ResponseStatus status = ResponseStatus.OK;
    protected String type;
    protected List<ApiError> errors = new ArrayList<>();
    protected Long total;

    public BasicResponse() {
        status = ResponseStatus.OK;
    }

    public BasicResponse(ConstraintViolationException ex) {
        status = ResponseStatus.ERROR;
        type = ex.getClass().getSimpleName();

        if (ex.getConstraintViolations().isEmpty()) {
            appendToErrors("error", ex.getMessage());
        } else {
            for (ConstraintViolation<?> violation : ex.getConstraintViolations()) {
                appendToErrors(violation.getPropertyPath().toString(), violation.getMessage());
            }
        }
    }

    public BasicResponse(BusinessLogicException ex) {
        status = ResponseStatus.ERROR;
        type = ex.getClass().getSimpleName();

        if (ex.namesSpecificProperty()) {
            appendToErrors(ex.getPropertyName(), ex.getMessage());
        } else {
            appendToErrors("error", ex.getMessage());
        }
    }

    @JsonInclude
    @ApiModelProperty(dataType = "string")
    public ResponseStatus getStatus() {
        return status;
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    @JsonInclude
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonInclude
    public List<ApiError> getErrors() {
        return errors;
    }

    public void setErrors(List<ApiError> errors) {
        this.errors = errors;
    }

    @JsonInclude
    public Long getTotal() {
        if (total == null) {
            return 0L;
        }

        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    private void appendToErrors(String key, String message) {
        ApiError error = getError(key);
        if (error == null) {
            error = new ApiError(key, new ArrayList<String>());
            errors.add(error);
        }

        error.getMessages().add(message);
    }

    @JsonIgnore
    public ApiError getError(String field) {
        for (ApiError e : errors) {
            if (e.getValue() != null && e.getValue().equals(field)) {
                return e;
            }
        }

        return null;
    }
}
