package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.leanix.dropkit.api.Link;
import net.leanix.dropkit.api.LinkProvider;
import org.slf4j.LoggerFactory;

/**
 * Account representation
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account implements Serializable, AuthenticatedUserAccount, LinkProvider {

    private UUID id;

    private String name;

    private final List<Link> links = new ArrayList<>();

    public Account() {
        this.id = null;
        this.name = null;
    }

    public Account(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    @JsonProperty
    @ApiModelProperty(dataType = "string")
    @Override
    public UUID getId() {
        return id;
    }

    @JsonProperty
    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    /**
     * The HATEOAS relations.
     *
     * @return
     */
    @Override
    @JsonProperty
    public List<Link> getLinks() {
        return links;
    }
}
