package net.leanix.dropkit;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import net.leanix.dropkit.swagger.SwaggerConfiguration;

/**
 *
 * @author andre
 */
public class DropkitConfiguration extends Configuration {

    @JsonProperty("swagger")
    private final SwaggerConfiguration swaggerConfig = new SwaggerConfiguration();

    @JsonProperty("oauth")
    private final OAuth2ClientConfig oauth = new OAuth2ClientConfig();

    public SwaggerConfiguration getSwaggerConfig() {
        return this.swaggerConfig;
    }

    /**
     * Returns the necessary configuration to run oauth resource providers.
     *
     * Values can be empty.
     *
     * @return
     */
    public OAuth2ClientConfig getOAuthConfiguration() {
        return oauth;
    }
}
