/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.leanix.dropkit.BusinessLogicException;
import net.leanix.dropkit.api.ApiError;
import net.leanix.dropkit.responses.ResponseStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BasicResponse {
    protected ResponseStatus status = ResponseStatus.OK;
    protected String type;
    protected List<ApiError> errors = new ArrayList<ApiError>();
    protected Long total;

    public BasicResponse() {
        this.status = ResponseStatus.OK;
    }

    public BasicResponse(ConstraintViolationException ex) {
        this.status = ResponseStatus.ERROR;
        this.type = ex.getClass().getSimpleName();
        if (ex.getConstraintViolations().isEmpty()) {
            this.appendToErrors("error", ex.getMessage());
        } else {
            for (ConstraintViolation violation : ex.getConstraintViolations()) {
                this.appendToErrors(violation.getPropertyPath().toString(), violation.getMessage());
            }
        }
    }

    public BasicResponse(BusinessLogicException ex) {
        this.status = ResponseStatus.ERROR;
        this.type = ex.getClass().getSimpleName();
        if (ex.namesSpecificProperty()) {
            this.appendToErrors(ex.getPropertyName(), ex.getMessage());
        } else {
            this.appendToErrors("error", ex.getMessage());
        }
    }

    @JsonInclude
    @ApiModelProperty(dataType="string")
    public ResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    @JsonInclude
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonInclude
    public List<ApiError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ApiError> errors) {
        this.errors = errors;
    }

    @JsonInclude
    public Long getTotal() {
        if (this.total == null) {
            return 0L;
        }
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    private void appendToErrors(String key, String message) {
        ApiError error = this.getError(key);
        if (error == null) {
            error = new ApiError(key, new ArrayList<String>());
            this.errors.add(error);
        }
        error.getMessages().add(message);
    }

    @JsonIgnore
    public ApiError getError(String field) {
        for (ApiError e : this.errors) {
            if (e.getValue() == null || !e.getValue().equals(field)) continue;
            return e;
        }
        return null;
    }
}

