/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import net.leanix.dropkit.api.ClientFactory;
import net.leanix.dropkit.oauth.AccessTokenResponse;
import net.leanix.dropkit.oauth.FlowException;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import net.leanix.dropkit.oauth.VerifyTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialAccessTokenFactory {
    private final OAuth2ClientConfig config;
    private final String authorization;
    private final Client apiClient;
    private final Logger logger;
    private AccessTokenResponse accessTokenResponse;
    private final long expireGraceTime = 10L;

    public static ClientCredentialAccessTokenFactory create(OAuth2ClientConfig config) {
        Client apiClient = ClientFactory.createJerseyClientWithJacksonSerializer();
        Logger logger = LoggerFactory.getLogger(ClientCredentialAccessTokenFactory.class);
        return new ClientCredentialAccessTokenFactory(config, apiClient, logger);
    }

    public ClientCredentialAccessTokenFactory(OAuth2ClientConfig config, Client apiClient, Logger logger) {
        this.authorization = "Basic ".concat(new String(Base64.encode((byte[])config.getClientId().concat(":").concat(config.getClientSecret()).getBytes())));
        this.config = config;
        this.apiClient = apiClient;
        this.logger = logger;
    }

    public String getAccessToken() throws FlowException {
        if (this.getAccessTokenResponse() == null || !this.verifyToken()) {
            this.fetchToken();
        }
        return this.getAccessTokenResponse().getAccessToken();
    }

    protected AccessTokenResponse getAccessTokenResponse() {
        return this.accessTokenResponse;
    }

    private boolean verifyToken() throws FlowException {
        VerifyTokenResponse verificationResponse = null;
        try {
            verificationResponse = (VerifyTokenResponse)((WebResource.Builder)this.apiClient.resource(String.format(this.config.getVerificationUrl().concat("?access_token=%s"), this.accessTokenResponse.getAccessToken())).accept(new String[]{"application/json"}).header("Authorization", (Object)this.authorization)).get(VerifyTokenResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            this.logger.info("Failed to verify access_token " + this.config.getTokenUrl() + " using " + this.authorization + " against " + this.config.getVerificationUrl(), ex);
            return false;
        }
        if (verificationResponse == null) {
            this.throwFlowException("Verification response null against " + this.config.getVerificationUrl());
        }
        if ((verificationResponse.getError() == null || verificationResponse.getError().isEmpty()) && verificationResponse.getExpiresIn() > 10L) {
            this.logger.debug("Successful access token " + this.accessTokenResponse.getAccessToken() + " verification, expires in " + verificationResponse.getExpiresIn() + " sec");
            return true;
        }
        this.logger.debug("Unable to verify access token " + this.accessTokenResponse.getAccessToken() + ", error = " + verificationResponse.getError() + " expire = " + verificationResponse.getExpiresIn());
        return false;
    }

    private void fetchToken() throws FlowException {
        try {
            this.accessTokenResponse = (AccessTokenResponse)((WebResource.Builder)((WebResource.Builder)this.apiClient.resource(this.config.getTokenUrl().concat("?grant_type=client_credentials")).accept(new String[]{"application/json"}).header("Authorization", (Object)this.authorization)).header("Accept", (Object)"application/json")).post(AccessTokenResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            this.throwFlowException("Failed to retrieve a new oauth token from " + this.config.getTokenUrl() + " using " + this.authorization + " against " + this.config.getTokenUrl(), (Exception)ex);
        }
        this.logger.info("Fetched a new token: " + this.accessTokenResponse.getAccessToken());
    }

    private void throwFlowException(String message, Exception ex) throws FlowException {
        this.logger.error(message, (Throwable)ex);
        throw new FlowException(message);
    }

    private void throwFlowException(String message) throws FlowException {
        this.logger.error(message);
        throw new FlowException(message);
    }
}

