/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import net.leanix.dropkit.oauth.Permission;
import net.leanix.dropkit.oauth.PermissionRole;
import net.leanix.dropkit.oauth.PermissionStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PermissionTest {
    private Permission permission;

    @Before
    public void setup() {
        this.permission = new Permission();
        this.permission.setStatus(PermissionStatus.ACTIVE);
        this.permission.setRole(PermissionRole.ADMIN);
    }

    @Test
    public void isActive() {
        Assert.assertTrue((boolean)this.permission.isActive());
    }

    @Test
    public void isNotActive() {
        this.permission.setStatus(PermissionStatus.ARCHIVED);
        Assert.assertFalse((boolean)this.permission.isActive());
    }

    @Test
    public void hasRole() {
        Assert.assertTrue((boolean)this.permission.hasRole(PermissionRole.ADMIN));
    }

    @Test
    public void hasNotRole() {
        Assert.assertFalse((boolean)this.permission.hasRole(PermissionRole.CONTACT));
    }

    @Test
    public void isActiveRole() {
        Assert.assertTrue((boolean)this.permission.isActive(PermissionRole.ADMIN));
    }

    @Test
    public void isNotActiveRole() {
        this.permission.setStatus(PermissionStatus.ARCHIVED);
        Assert.assertFalse((boolean)this.permission.isActive(PermissionRole.ADMIN));
    }
}

