/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.sun.jersey.api.client.WebResource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client {
    private final String baseUrl;
    private final com.sun.jersey.api.client.Client apiClient;
    private Cache cache;

    public Client(String baseUrl, com.sun.jersey.api.client.Client apiClient) {
        this.baseUrl = baseUrl;
        this.apiClient = apiClient;
    }

    public Client(String baseUrl, com.sun.jersey.api.client.Client apiClient, Cache cache) {
        this.baseUrl = baseUrl;
        this.apiClient = apiClient;
        this.cache = cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public WebResource resource(String path) {
        return this.apiClient.resource(this.getUrl(path));
    }

    public Object getCachedGet(String url) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getIfPresent((Object)url);
    }

    public void setCachedGet(String url, Object o) {
        if (this.cache == null) {
            return;
        }
        this.cache.put((Object)url, o);
    }

    public Object getCachedPost(String url, Object o) {
        if (this.cache == null) {
            return null;
        }
        try {
            return this.cache.getIfPresent((Object)(url + this.getObjectStringHash(o)));
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
    }

    public void setCachedPost(String url, Object o, Object result) {
        if (this.cache == null) {
            return;
        }
        try {
            String key = url + this.getObjectStringHash(o);
            this.cache.put((Object)key, result);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    public String getUrl(String path) {
        return this.baseUrl + path;
    }

    private int getObjectStringHash(Object o) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(o).hashCode();
    }
}

