/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import net.leanix.dropkit.api.ApiError;
import net.leanix.dropkit.responses.BasicResponse;
import net.leanix.dropkit.responses.TestModel;
import org.fest.assertions.api.Assertions;
import org.junit.Test;

public class BasicResponseTest {
    @Test
    public void containsTheErrorsAsMap() throws JsonProcessingException {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        ConstraintViolationException ex = new ConstraintViolationException(validator.validate((Object)new TestModel(), new Class[0]));
        BasicResponse response = new BasicResponse(ex);
        List errors = response.getErrors();
        Assertions.assertThat((Object)response.getError("id")).isNotNull();
        Assertions.assertThat((Object)response.getError("id")).isInstanceOf(ApiError.class);
        ObjectMapper mapper = new ObjectMapper();
        Assertions.assertThat((String)mapper.writeValueAsString((Object)response)).contains("\"errors\":[{\"value\":\"id\",\"messages\":[");
    }

    @Test
    public void returnsZeroIfTotalIsNull() {
        BasicResponse res = new BasicResponse();
        Assertions.assertThat((Long)res.getTotal()).isEqualTo(0L);
    }
}

