/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import net.leanix.dropkit.oauth.AccessTokenResponse;
import net.leanix.dropkit.oauth.ClientCredentialAccessTokenFactory;
import net.leanix.dropkit.oauth.FlowException;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import net.leanix.dropkit.oauth.VerifyTokenResponse;
import org.fest.assertions.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class ClientCredentialAccessTokenFactoryTest {
    private ClientCredentialAccessTokenFactory factory;
    private Client apiClient = (Client)Mockito.mock(Client.class);
    private Logger logger = (Logger)Mockito.mock(Logger.class);
    private AccessTokenResponse response;
    private WebResource.Builder builder = (WebResource.Builder)Mockito.mock(WebResource.Builder.class);
    private OAuth2ClientConfig config;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() {
        this.config = new OAuth2ClientConfig();
        this.config.setBaseUrl("https://test-mtm.leanix.net/services/");
        this.config.setTokenUrl("https://test-mtm.leanix.net/oauth/token");
        this.config.setVerificationUrl("https://test-mtm.leanix.net/oauth/token");
        this.config.setClientId("mtm");
        this.config.setClientSecret("mtm");
        this.factory = new ClientCredentialAccessTokenFactory(this.config, this.apiClient, this.logger);
        WebResource tokenResource = (WebResource)Mockito.mock(WebResource.class);
        WebResource verificationResource = (WebResource)Mockito.mock(WebResource.class);
        Mockito.when((Object)this.apiClient.resource(Matchers.startsWith((String)this.config.getTokenUrl()))).thenReturn((Object)tokenResource);
        Mockito.when((Object)this.apiClient.resource(Matchers.startsWith((String)this.config.getVerificationUrl()))).thenReturn((Object)verificationResource);
        Mockito.when((Object)this.builder.header(Matchers.anyString(), (Object)Matchers.anyString())).thenReturn((Object)this.builder);
        Mockito.when((Object)tokenResource.accept(new String[]{Matchers.anyString()})).thenReturn((Object)this.builder);
        Mockito.when((Object)verificationResource.accept(new String[]{Matchers.anyString()})).thenReturn((Object)this.builder);
        this.response = new AccessTokenResponse("abc", "access_token", 3600L, null, null);
        Mockito.when((Object)this.builder.post(AccessTokenResponse.class)).thenReturn((Object)this.response);
    }

    @Test
    public void fetchesTokenFirstTime() throws FlowException {
        String accessToken = this.factory.getAccessToken();
        Assertions.assertThat((String)accessToken).isEqualTo((Object)"abc");
        ((WebResource.Builder)Mockito.verify((Object)this.builder)).post(AccessTokenResponse.class);
    }

    @Test
    public void exceptionAtFetch() throws FlowException {
        Mockito.when((Object)this.builder.post(AccessTokenResponse.class)).thenThrow(new Throwable[]{new UniformInterfaceException("test", (ClientResponse)Mockito.mock(ClientResponse.class), false)});
        this.exception.expect(FlowException.class);
        this.factory.getAccessToken();
    }

    @Test
    public void doesNotFetchIfTokenIsValid() throws FlowException {
        this.factory.getAccessToken();
        VerifyTokenResponse verifyResponse = new VerifyTokenResponse();
        verifyResponse.setExpiresIn(Long.valueOf(20L));
        Mockito.when((Object)this.builder.get(VerifyTokenResponse.class)).thenReturn((Object)verifyResponse);
        this.factory.getAccessToken();
        ((WebResource.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.times((int)1))).post(AccessTokenResponse.class);
    }

    @Test
    public void fetchesNewTokenIfInvalid() throws FlowException {
        this.factory.getAccessToken();
        VerifyTokenResponse verifyResponse = new VerifyTokenResponse("invalid_token");
        Mockito.when((Object)this.builder.get(VerifyTokenResponse.class)).thenReturn((Object)verifyResponse);
        this.factory.getAccessToken();
        ((WebResource.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.times((int)2))).post(AccessTokenResponse.class);
    }

    @Test
    public void fetchesNewTokenIfExpired() throws FlowException {
        this.factory.getAccessToken();
        VerifyTokenResponse verifyResponse = new VerifyTokenResponse("token_expired");
        Mockito.when((Object)this.builder.get(VerifyTokenResponse.class)).thenReturn((Object)verifyResponse);
        this.factory.getAccessToken();
        ((WebResource.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.times((int)2))).post(AccessTokenResponse.class);
    }

    @Test
    public void fetchesNewTokenIfExpiresSoon() throws FlowException {
        this.factory.getAccessToken();
        VerifyTokenResponse verifyResponse = new VerifyTokenResponse();
        verifyResponse.setExpiresIn(Long.valueOf(2L));
        Mockito.when((Object)this.builder.get(VerifyTokenResponse.class)).thenReturn((Object)verifyResponse);
        this.factory.getAccessToken();
        ((WebResource.Builder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.times((int)2))).post(AccessTokenResponse.class);
    }
}

