package net.leanix.dropkit.oauth;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import org.joda.time.DateTime;

/**
 * Permission for a user to access a workspace.
 *
 * Defaults to active contact.
 *
 */
public interface WorkspacePermission {

    @ApiModelProperty(dataType = "string")
    UUID getWorkspaceId();

    /**
     * Returns the status the user has in the workspace.
     *
     * @return
     */
    @ApiModelProperty(dataType = "string")
    public PermissionStatus getStatus();

    /**
     * Returns the time of the last login in the workspace.
     *
     * @return
     */
    public DateTime getLastLogin();

    /**
     * Convenience method to check user status.
     *
     * @return
     */
    @ApiModelProperty(hidden = true)
    public boolean isActive();

    /**
     * Convenience method to check user status and the given role.
     *
     * @param role
     * @return
     */
    @ApiModelProperty(hidden = true)
    public boolean isActive(PermissionRole role);

    /**
     * Checks if the resource owner has the given role in the workspace.
     *
     * @param role
     * @return
     */
    @ApiModelProperty(hidden = true)
    public boolean hasRole(PermissionRole role);
}
