/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import net.leanix.dropkit.api.Client;
import net.leanix.dropkit.oauth.ClientCredentialAccessTokenFactory;
import net.leanix.dropkit.oauth.ClientCredentialsApiAuthFilter;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;

public class ClientFactory {
    public static Client create(OAuth2ClientConfig config) {
        URI tokenURI = URI.create(config.getTokenUrl());
        com.sun.jersey.api.client.Client c = ClientFactory.createJerseyClientWithJacksonSerializer();
        c.setFollowRedirects(Boolean.TRUE);
        c.addFilter((ClientFilter)ClientFactory.getAuthFilter(ClientCredentialAccessTokenFactory.create(config)));
        return new Client(config.getBaseUrl(), c);
    }

    public static Client create(String baseUrl, String tokenUrl, String verificationUrl, String clientId, String clientSecret) {
        OAuth2ClientConfig config = new OAuth2ClientConfig();
        config.setBaseUrl(baseUrl);
        config.setTokenUrl(tokenUrl);
        config.setVerificationUrl(verificationUrl);
        config.setClientId(clientId);
        config.setClientSecret(clientSecret);
        return ClientFactory.create(config);
    }

    public static Client create(String baseUrl) {
        com.sun.jersey.api.client.Client c = ClientFactory.createJerseyClientWithJacksonSerializer();
        c.setFollowRedirects(Boolean.TRUE);
        return new Client(baseUrl, c);
    }

    public static com.sun.jersey.api.client.Client createJerseyClientWithJacksonSerializer() {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(JacksonJsonProvider.class);
        return com.sun.jersey.api.client.Client.create((ClientConfig)cc);
    }

    private static ClientCredentialsApiAuthFilter getAuthFilter(ClientCredentialAccessTokenFactory factory) {
        return new ClientCredentialsApiAuthFilter(factory);
    }
}

