package net.leanix.dropkit.swagger;

import com.google.common.base.Charsets;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Environment;
import net.leanix.dropkit.DropkitConfiguration;

/**
 * App init helper for swagger integration.
 *
 *
 */
public class SwaggerStaticAppHelper {

    /**
     * Registers asset bundles and a json spec rewrite filter.
     *
     * @param config
     * @param environment
     */
    public static void run(DropkitConfiguration config, Environment environment) {
        new AssetsBundle("/swagger", "/docs", "index.html", "swagger").run(environment);

        environment.servlets().addServlet(
                "api-docs",
                new ApiDocsAssetServlet("/api-docs", "/api-docs", "service.json", Charsets.UTF_8, config.getSwaggerConfig().getBasePath())
        ).addMapping("/api-docs/*");
    }
}
