/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.leanix.dropkit.api.DateTimeDeserializer;
import net.leanix.dropkit.api.Link;
import net.leanix.dropkit.api.LinkProvider;
import net.leanix.dropkit.oauth.PermissionRole;
import net.leanix.dropkit.oauth.PermissionStatus;
import net.leanix.dropkit.oauth.WorkspacePermission;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Permission
implements Serializable,
WorkspacePermission,
LinkProvider {
    private UUID id;
    private UUID workspaceId;
    private PermissionRole role;
    private PermissionStatus status = PermissionStatus.ACTIVE;
    private DateTime lastLogin;
    private final List<Link> links = new ArrayList<Link>();

    public Permission() {
        this.lastLogin = new DateTime();
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @ApiModelProperty(dataType="string")
    public UUID getId() {
        return this.id;
    }

    @Override
    @ApiModelProperty(dataType="string")
    public UUID getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
    }

    @Override
    @ApiModelProperty(dataType="string")
    public PermissionStatus getStatus() {
        return this.status;
    }

    public void setStatus(PermissionStatus status) {
        this.status = status;
    }

    @Override
    @JsonSerialize(using=DateTimeSerializer.class)
    public DateTime getLastLogin() {
        return this.lastLogin;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public void setLastLogin(DateTime lastLogin) {
        this.lastLogin = lastLogin;
    }

    @Override
    @JsonIgnore
    public boolean isActive() {
        return PermissionStatus.ACTIVE.equals((Object)this.status);
    }

    @Override
    @JsonIgnore
    public boolean isActive(PermissionRole role) {
        return this.isActive() && this.hasRole(role);
    }

    public PermissionRole getRole() {
        return this.role;
    }

    public void setRole(PermissionRole role) {
        this.role = role;
    }

    @Override
    public boolean hasRole(PermissionRole role) {
        return this.role != null && this.role.equals((Object)role);
    }

    @Override
    @JsonProperty
    public List<Link> getLinks() {
        return this.links;
    }

    public String toString() {
        return "[Permission: Workspace " + this.workspaceId + ", role " + (Object)((Object)this.role) + ", status " + this.status.toString() + "]";
    }
}

