package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Configuration for oauth resource providers.
 *
 *
 */
public class OAuth2ClientConfig {

    private String baseUrl;

    private String tokenUrl;

    /**
     * Oauth auth server url.
     */
    @JsonProperty
    private String verificationUrl;

    /**
     * The key/identifier of the resource server.
     */
    @JsonProperty
    private String clientId;

    /**
     * The shared secret of the resource server.
     */
    @JsonProperty
    private String clientSecret;

    public String getVerificationUrl() {
        return verificationUrl;
    }

    public void setVerificationUrl(String verificationUrl) {
        this.verificationUrl = verificationUrl;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getTokenUrl() {
        return tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

}
