package net.leanix.dropkit.oauth;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import javax.ws.rs.core.HttpHeaders;

/**
 * Adds oauth access token to requests.
 *
 *
 * @todo this is a poc. to be replaced with an oauth library
 */
public class ClientCredentialsApiAuthFilter extends ClientFilter {

    /**
     * Constant for the access token (oauth2 spec).
     */
    private static final String BEARER = "Bearer";

    /**
     * The factory that calls the oauth auth server when a token is needed.
     */
    private final ClientCredentialAccessTokenFactory accessTokenFactory;

    /**
     * Constructor.
     *
     * @param accessTokenFactory inject the access token factory
     */
    public ClientCredentialsApiAuthFilter(ClientCredentialAccessTokenFactory accessTokenFactory) {
        this.accessTokenFactory = accessTokenFactory;
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        try {
            cr.getHeaders().remove(HttpHeaders.AUTHORIZATION);
            cr.getHeaders().add(HttpHeaders.AUTHORIZATION, BEARER + " " + accessTokenFactory.getAccessToken());
        } catch (FlowException ex) {
            throw new ClientHandlerException("Failed to attach bearer token", ex);
        }

        ClientHandler next = getNext();
        if (next != null) {
            return next.handle(cr);
        }

        return null;
    }

}
