package net.leanix.dropkit;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.eclipse.jetty.servlets.CrossOriginFilter;

/**
 * Application initialisation helper.
 *
 */
public class AppHelper {

    /**
     * Inits the use of iso8501 time format.
     *
     * @param bootstrap
     */
    public void initializeISO8601(Bootstrap<? extends Configuration> bootstrap) {
        bootstrap.getObjectMapper().registerModule(new JodaModule());
        bootstrap.getObjectMapper().setDateFormat(new ISO8601DateFormat());
    }

    /**
     * Registers mappers for invalid-entity and business logic exception.
     *
     *
     * @param environment
     */
    public void registerExceptionMappers(Environment environment) {
        //exception mappers
        environment.jersey().register(new InvalidEntityMapper());
        environment.jersey().register(new BusinessLogicExceptionMapper());
    }

    /**
     * Enables cross-origin requests.
     *
     *
     * @param environment
     */
    public void addCORSFilter(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, "/*");
        filter.setInitParameter(CrossOriginFilter.ALLOWED_ORIGINS_PARAM, "*");
        filter.setInitParameter(CrossOriginFilter.ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, "*");
        filter.setInitParameter(CrossOriginFilter.ALLOWED_HEADERS_PARAM, "accept,accept-encoding,accept-language,access-control-request-headers,access-control-request-method,api-key,authorization,cache-control,content-type,content-length,connection,host,pragma,referer,x-requested-with,origin,x-api-sync-mode,x-api-key");
        filter.setInitParameter(CrossOriginFilter.ALLOWED_METHODS_PARAM, "GET,PUT,POST,DELETE,OPTIONS");
        filter.setInitParameter(CrossOriginFilter.PREFLIGHT_MAX_AGE_PARAM, "5184000"); // 2 months
        filter.setInitParameter(CrossOriginFilter.ALLOW_CREDENTIALS_PARAM, "true");
    }
}
