/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import net.leanix.dropkit.oauth.ClientCredentialAccessTokenFactory;
import net.leanix.dropkit.oauth.FlowException;

public class ClientCredentialsApiAuthFilter
extends ClientFilter {
    private static final String BEARER = "Bearer";
    private final ClientCredentialAccessTokenFactory accessTokenFactory;

    public ClientCredentialsApiAuthFilter(ClientCredentialAccessTokenFactory accessTokenFactory) {
        this.accessTokenFactory = accessTokenFactory;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        try {
            cr.getHeaders().remove((Object)"Authorization");
            cr.getHeaders().add((Object)"Authorization", (Object)("Bearer " + this.accessTokenFactory.getAccessToken()));
        }
        catch (FlowException ex) {
            throw new ClientHandlerException("Failed to attach bearer token", (Throwable)ex);
        }
        ClientHandler next = this.getNext();
        if (next != null) {
            return next.handle(cr);
        }
        return null;
    }
}

