/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.URI;
import net.leanix.dropkit.api.IntegrationTests;
import net.leanix.dropkit.oauth.ClientCredentialAccessTokenFactory;
import net.leanix.dropkit.oauth.FlowException;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class CredentialClientConnectionTest {
    @Test
    public void getAccessToken() throws FlowException {
        URI tokenUri = URI.create("https://local-dev.leanix.net/services/mtm/oauth2/token");
        DefaultClientConfig defaultClientConfig = new DefaultClientConfig();
        defaultClientConfig.getClasses().add(JacksonJsonProvider.class);
        Client client = Client.create((ClientConfig)defaultClientConfig);
        OAuth2ClientConfig config = new OAuth2ClientConfig();
        config.setBaseUrl("https://test-mtm.leanix.net/services/");
        config.setTokenUrl("https://test-mtm.leanix.net/oauth/token");
        config.setVerificationUrl("https://test-mtm.leanix.net/oauth/token");
        config.setClientId("mtm");
        config.setClientSecret("mtm");
        ClientCredentialAccessTokenFactory factory = new ClientCredentialAccessTokenFactory(config, client, LoggerFactory.getLogger(CredentialClientConnectionTest.class));
        String accessToken = factory.getAccessToken();
        Assertions.assertThat((String)accessToken).isNotEmpty();
    }
}

