/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import com.google.common.cache.Cache;
import java.util.List;
import net.leanix.dropkit.api.Client;
import org.fest.assertions.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ClientTest {
    @Test
    public void prependsBaseUrl() {
        com.sun.jersey.api.client.Client mock = (com.sun.jersey.api.client.Client)Mockito.mock(com.sun.jersey.api.client.Client.class);
        Client client = new Client("abc", mock);
        client.resource("def");
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((com.sun.jersey.api.client.Client)Mockito.verify((Object)mock)).resource((String)captor.capture());
        List captured = captor.getAllValues();
        Assert.assertEquals((Object)"abcdef", captured.get(0));
    }

    @Test
    public void usesCache() {
        Cache cache = (Cache)Mockito.mock(Cache.class);
        TestClientSpy spy = new TestClientSpy("abc", (com.sun.jersey.api.client.Client)Mockito.mock(com.sun.jersey.api.client.Client.class), cache);
        Mockito.when((Object)cache.getIfPresent(Matchers.any(String.class))).thenReturn((Object)"some string");
        Object res = spy.getCachedGet("def");
        ((Cache)Mockito.verify((Object)cache)).getIfPresent((Object)"def");
        Assertions.assertThat((Object)res).isEqualTo((Object)"some string");
    }

    @Test
    public void doesNotUseCacheIfHasNone() {
        TestClientSpy spy = new TestClientSpy("abc", (com.sun.jersey.api.client.Client)Mockito.mock(com.sun.jersey.api.client.Client.class));
        Assertions.assertThat((Object)spy.getCachedGet("def")).isNull();
    }

    @Test
    public void usesCacheForPost() {
        Cache cache = (Cache)Mockito.mock(Cache.class);
        TestClientSpy spy = new TestClientSpy("abc", (com.sun.jersey.api.client.Client)Mockito.mock(com.sun.jersey.api.client.Client.class), cache);
        Mockito.when((Object)cache.getIfPresent(Matchers.any(String.class))).thenReturn((Object)"some string");
        Object res = spy.getCachedPost(Matchers.anyString(), new FeatureAccessRequest());
        ((Cache)Mockito.verify((Object)cache)).getIfPresent((Object)Matchers.anyString());
        Assertions.assertThat((Object)res).isEqualTo((Object)"some string");
    }

    @Test
    public void usesSameHashCode() {
        Cache cache = (Cache)Mockito.mock(Cache.class);
        TestClientSpy spy = new TestClientSpy("abc", (com.sun.jersey.api.client.Client)Mockito.mock(com.sun.jersey.api.client.Client.class), cache);
        Mockito.when((Object)cache.getIfPresent(Matchers.any(String.class))).thenReturn((Object)"some string");
        spy.getCachedPost("def", new FeatureAccessRequest());
        ((Cache)Mockito.verify((Object)cache)).getIfPresent((Object)"def-976925241");
    }

    @Test
    public void usesSameHashCodeForPost() {
        Cache cache = (Cache)Mockito.mock(Cache.class);
        TestClientSpy spy = new TestClientSpy("abc", (com.sun.jersey.api.client.Client)Mockito.mock(com.sun.jersey.api.client.Client.class), cache);
        spy.setCachedPost("def", new FeatureAccessRequest(), new Object());
        ((Cache)Mockito.verify((Object)cache)).put(Mockito.eq((Object)"def-976925241"), Matchers.any(Object.class));
    }

    class FeatureAccessRequest {
        public String edition;

        FeatureAccessRequest() {
        }
    }

    class TestClientSpy
    extends Client {
        public TestClientSpy(String baseUrl, com.sun.jersey.api.client.Client apiClient) {
            super(baseUrl, apiClient);
        }

        public TestClientSpy(String baseUrl, com.sun.jersey.api.client.Client apiClient, Cache cache) {
            super(baseUrl, apiClient, cache);
        }
    }
}

