package net.leanix.dropkit.oauth;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;

/**
 * Interface to identify an authenticated user.
 *
 *
 */
public interface AuthenticatedUser {

    /**
     * Returns the UUID string representation for regular users or a resource
     * server key or a client key.
     *
     * @return
     */
    String getIdentifier();

    /**
     * Returns the username.
     *
     * @return
     */
    String getUserName();

    /**
     * Returns the account (=company).
     *
     * @return
     */
    AuthenticatedUserAccount getAccount();

    /**
     * Returns the role of the user in his company.
     *
     * @return
     */
    @ApiModelProperty(dataType = "string")
    UserRole getRole();

    /**
     * Return the status of the user.
     *
     * @return
     */
    @ApiModelProperty(dataType = "string")
    UserStatus getStatus();

    /**
     * Convenience method to check if user is active and has the given role.
     *
     * @param role
     * @return
     */
    @ApiModelProperty(hidden = true)
    boolean isActive(UserRole role);

    /**
     * Returns the permission for all the workspaces.
     *
     * @return
     */
    List<WorkspacePermission> getPermissions();

}
