/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.util.Date;
import net.leanix.dropkit.oauth.models.Principal;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2TokenParser {
    OAuth2TokenConfig config;
    Key key;

    public OAuth2TokenParser(OAuth2TokenConfig config) throws Exception {
        this.config = config;
        this.key = config.getSigningKey();
    }

    public OAuth2Token parse(String accessToken) throws Exception {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(accessToken).getBody();
        ObjectMapper mapper = new ObjectMapper();
        Principal user = (Principal)mapper.convertValue(claims.get((Object)"principal"), User.class);
        OAuth2Token token = new OAuth2Token();
        token.setPrincipal(user);
        token.setExpiration(claims.getExpiration());
        if (claims.get((Object)"refresh_token") != null) {
            token.setRefreshToken((String)claims.get("refresh_token", String.class));
        }
        if (claims.get((Object)"refresh_expiration") != null) {
            token.setRefreshExpiration((Date)claims.get("refresh_exp", Date.class));
        }
        return token;
    }
}

