/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.token;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.io.IOUtils;

public class KeyReaderRSA {
    public static PrivateKey getPrivateKey(String filename) throws Exception {
        return KeyReaderRSA.getPrivateKey(new FileInputStream(new File(filename)));
    }

    public static PrivateKey getPrivateKey(InputStream stream) throws Exception {
        byte[] keyBytes = IOUtils.toByteArray((InputStream)stream);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }

    public static PublicKey getPublicKey(String filename) throws Exception {
        return KeyReaderRSA.getPublicKey(new FileInputStream(new File(filename)));
    }

    public static PublicKey getPublicKey(InputStream stream) throws Exception {
        byte[] keyBytes = IOUtils.toByteArray((InputStream)stream);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }
}

