/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import net.leanix.dropkit.api.ClientFactory;
import net.leanix.dropkit.oauth.FlowException;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import net.leanix.dropkit.oauth.responses.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialAccessTokenFactory {
    private final OAuth2ClientConfig config;
    private final String authorization;
    private final Client apiClient;
    private final Logger logger = LoggerFactory.getLogger(ClientCredentialAccessTokenFactory.class);
    private AccessTokenResponse accessTokenResponse;

    public static ClientCredentialAccessTokenFactory create(OAuth2ClientConfig config) {
        Client apiClient = ClientFactory.createJerseyClientWithJacksonSerializer();
        return new ClientCredentialAccessTokenFactory(config, apiClient);
    }

    public ClientCredentialAccessTokenFactory(OAuth2ClientConfig config, Client apiClient) {
        this.authorization = "Basic ".concat(new String(Base64.encode((byte[])config.getClientId().concat(":").concat(config.getClientSecret()).getBytes())));
        this.config = config;
        this.apiClient = apiClient;
    }

    public String getAccessToken() throws FlowException {
        if (this.accessTokenResponse == null) {
            this.fetchToken();
        } else if (this.accessTokenResponse.isExpired()) {
            this.fetchToken();
        }
        return this.accessTokenResponse.getAccessToken();
    }

    private void fetchToken() throws FlowException {
        try {
            this.accessTokenResponse = (AccessTokenResponse)((WebResource.Builder)((WebResource.Builder)this.apiClient.resource(this.config.getTokenUrl().concat("?grant_type=client_credentials")).accept(new String[]{"application/json"}).header("Authorization", (Object)this.authorization)).header("Accept", (Object)"application/json")).post(AccessTokenResponse.class);
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            this.throwFlowException("Failed to retrieve a new oauth token from " + this.config.getTokenUrl() + " using " + this.authorization, (Exception)ex);
        }
    }

    private void throwFlowException(String message, Exception ex) throws FlowException {
        this.logger.error(message, (Throwable)ex);
        throw new FlowException(message);
    }
}

