/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.persistence;

import net.leanix.dropkit.BusinessLogicException;
import net.leanix.dropkit.persistence.PageRequest;
import org.assertj.core.api.Assertions;
import org.hibernate.NullPrecedence;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PageRequestTest {
    private PageRequest request;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void sizeExceedsMaxSize() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, null, 80);
        this.exception.expect(BusinessLogicException.class);
        this.request.setSize(81);
    }

    @Test
    public void equalsMaxSize() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, null, 80);
        this.request.setSize(80);
    }

    @Test
    public void unlimitedMaxsize() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, null, -1);
        this.request.setSize(10000000);
    }

    @Test
    public void addsIdSortAsSecondarySortField() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, null, 80);
        this.request.setSort("abc-asc");
        Assertions.assertThat((String)this.request.getSort()).endsWith((CharSequence)",id-asc");
    }

    @Test
    public void doesNotAddIdSortIfNull() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, null, 80);
        Assertions.assertThat((String)this.request.getSort()).isNull();
    }

    @Test
    public void sortNullsLastIsDefault() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, "name-asc");
        Assert.assertEquals((Object)NullPrecedence.LAST, (Object)this.request.getNullPrecedence());
        this.request = new PageRequest(1, 0, "name-asc", 80);
        Assert.assertEquals((Object)NullPrecedence.LAST, (Object)this.request.getNullPrecedence());
    }

    @Test
    public void nullPrecedenceCanBeSpecifiedInConstructor() throws BusinessLogicException {
        this.request = new PageRequest(1, 0, "name-asc", NullPrecedence.FIRST);
        Assert.assertEquals((Object)NullPrecedence.FIRST, (Object)this.request.getNullPrecedence());
        this.request = new PageRequest(1, 0, "name-asc", 80, NullPrecedence.FIRST);
        Assert.assertEquals((Object)NullPrecedence.FIRST, (Object)this.request.getNullPrecedence());
    }
}

