/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.persistence;

import net.leanix.dropkit.persistence.TransactionHandler;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TransactionHandlerTest {
    @Mock
    private SessionFactory sessionFactory;
    @Mock
    private Session session;
    @Mock
    private Transaction transaction;
    private TransactionHandler transactionHandler;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.sessionFactory.openSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.beginTransaction()).thenReturn((Object)this.transaction);
        this.transactionHandler = new TransactionHandler(this.sessionFactory);
    }

    @Test
    public void test_runInTransaction_SessionWillBeClosedOnExceptionsDuringCommit() {
        ((Transaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("commit failed")}).when((Object)this.transaction)).commit();
        this.transactionHandler.runInTransaction(() -> 1);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).clear();
        ((Session)Mockito.verify((Object)this.session)).close();
    }

    @Test
    public void test_executeInTransaction_SessionWillBeClosedOnExceptionsDuringRollback() {
        ((Transaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("commit failed")}).when((Object)this.transaction)).rollback();
        try {
            this.transactionHandler.executeInTransaction(() -> {
                throw new NullPointerException();
            });
        }
        catch (RuntimeException e) {
            ((Session)Mockito.verify((Object)this.session)).clear();
            ((Session)Mockito.verify((Object)this.session)).close();
        }
    }

    @Test
    public void test_runInSession_SessionWillBeClosedOnExceptions() {
        try {
            this.transactionHandler.runInSession(() -> {
                throw new NullPointerException();
            });
        }
        catch (RuntimeException e) {
            ((Session)Mockito.verify((Object)this.session)).close();
        }
    }
}

