package net.leanix.dropkit.persistence;

import com.google.inject.Inject;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;

/**
 * Hibernate session handling for use outside of dropwizard threads.
 *
 *
 */
public class SessionHandler {

    @Inject
    SessionFactory factory;

    private Session openedSession = null;

    /**
     * Opens a new session and binds the factory to ManagedSessionContext.
     *
     * @return
     */
    public Session openSession() {
        openedSession = factory.openSession();
        ManagedSessionContext.bind(openedSession);
        return openedSession;
    }

    /**
     * Closes the session and removes the binding.
     *
     * Calling this is a must, so best call it in a finally block.
     */
    public void closeSession() {
        openedSession.close();
        ManagedSessionContext.unbind(factory);
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }
}
