package net.leanix.dropkit.persistence;

/**
 * Object that represents data of a paginated request.
 *
 *
 */
public class PageRequest {

    private int page;
    private int size;
    private String sort;

    private int maxSize = 100;

    public PageRequest(int page, int size, String sort, int maxSize) throws IllegalArgumentException {
        setMaxSize(maxSize);
        setPage(page);
        setSize(size);
        setSort(sort);
    }

    public PageRequest(int page, int size, String sort) throws IllegalArgumentException {
        setPage(page);
        setSize(size);
        setSort(sort);
    }

    public int getPage() {
        return page;
    }

    public final void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return size;
    }

    public final void setSize(int size) throws IllegalArgumentException {
        if (maxSize > -1 && size > maxSize) {
            throw new IllegalArgumentException("Size exceeds maximum size of " + this.maxSize);
        }

        this.size = size;
    }

    /**
     * Returns the sorting param.
     *
     * #97768642 if sort is not empty, secondary sorting by id is added, since
     * otherwise paginated requests might contain results twice (items with
     * equal matches to the sort might be ordered randomly).
     *
     * @return
     */
    public String getSort() {
        String safe = sort;
        if (hasSort() && !sort.contains("id-")) {
            safe += ",id-asc";
        }

        return safe;
    }

    public final void setSort(String sort) {
        this.sort = sort;
    }

    public boolean hasSort() {
        return this.sort != null && !this.sort.isEmpty();
    }

    public final void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    /**
     * Disables paging by setting page and size to zero and maxSize to -1.
     */
    public void removePagingParams() {
        this.setPage(0);
        this.setSize(0);
        this.setMaxSize(-1);
    }
}
