package net.leanix.dropkit.persistence;

import org.hibernate.dialect.PostgreSQL9Dialect;
import java.sql.Types;

/**
 * Wrap default PostgreSQL9Dialect with 'json' type.
 *
 * @author timfulmer
 * http://stackoverflow.com/questions/15974474/mapping-postgresql-json-column-to-hibernate-value-type
 *
 * For hibernate postgres uuid issues:
 * http://stackoverflow.com/questions/11284359/persisting-uuid-in-postgresql-using-jpa
 * http://andrew-arch.blogspot.de/2008/02/uuid-and-hibernate-second-update.html
 */
public class JsonPostgreSQLDialect extends PostgreSQL9Dialect {

    public JsonPostgreSQLDialect() {
        super();
        registerColumnType(Types.JAVA_OBJECT, "json");
        registerColumnType(Types.OTHER, "uuid");
    }
}
