package net.leanix.dropkit.persistence;

import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Inject;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;

/**
 * A primitive database health check.
 *
 *
 *
 */
public class DatabaseHealthCheck extends HealthCheck {

    private final SessionFactory sessionFactory;

    @Inject
    public DatabaseHealthCheck(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected Result check() throws Exception {
        Session openedSession = sessionFactory.openSession();
        ManagedSessionContext.bind(openedSession);

        Result result = Result.unhealthy("Health status not checked");

        try {
            if (openedSession.isConnected()) {
                result = Result.healthy();
            } else {
                Result.unhealthy("DB Session is not connected.");
            }
        } catch (Exception ex) {
            result = Result.unhealthy(ex);
        } finally {
            openedSession.close();
            ManagedSessionContext.unbind(sessionFactory);
        }

        return result;
    }
}
