/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr.jackrabbit.ocm;

import java.util.Collection;
import net.leadware.spring.jcr.JcrExceptionUtils;
import net.leadware.spring.jcr.jackrabbit.ocm.OcmAction;
import net.leadware.spring.jcr.jackrabbit.ocm.OcmSessionFactory;
import net.leadware.spring.jcr.jackrabbit.ocm.OcmTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.manager.ObjectContentManager;
import org.apache.jackrabbit.ocm.query.Query;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class OcmTemplateImpl<T>
implements OcmTemplate<T>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected OcmSessionFactory sessionFactory;

    public OcmTemplateImpl() {
    }

    public OcmTemplateImpl(OcmSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public OcmSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(OcmSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Object execute(OcmAction<T> action, boolean autoSave) throws DataAccessException {
        ObjectContentManager ocm = null;
        try {
            ocm = this.sessionFactory.getOCM();
            Object result = action.execute(ocm);
            if (autoSave) {
                ocm.save();
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw JcrExceptionUtils.translateException(e);
        }
        finally {
            try {
                if (ocm != null) {
                    ocm.logout();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Object execute(OcmAction<T> action) throws DataAccessException {
        return this.execute(action, true);
    }

    @Override
    public T insert(final T entity) throws DataAccessException {
        return (T)this.execute(new OcmAction<T>(){

            @Override
            public Object execute(ObjectContentManager ocm) throws ObjectContentManagerException {
                ocm.insert(entity);
                return entity;
            }
        });
    }

    @Override
    public T update(final T entity) throws DataAccessException {
        return (T)this.execute(new OcmAction<T>(){

            @Override
            public Object execute(ObjectContentManager ocm) throws ObjectContentManagerException {
                ocm.update(entity);
                return entity;
            }
        });
    }

    @Override
    public void remove(final T entity) throws DataAccessException {
        this.execute(new OcmAction<T>(){

            @Override
            public Object execute(ObjectContentManager ocm) throws ObjectContentManagerException {
                ocm.remove(entity);
                return entity;
            }
        });
    }

    @Override
    public T findByPath(final String path) throws DataAccessException {
        return (T)this.execute(new OcmAction<T>(){

            @Override
            public Object execute(ObjectContentManager ocm) throws ObjectContentManagerException {
                return ocm.getObject(path);
            }
        });
    }

    @Override
    public Collection<T> filter(final Query query) throws DataAccessException {
        return (Collection)this.execute(new OcmAction<T>(){

            @Override
            public Object execute(ObjectContentManager ocm) throws ObjectContentManagerException {
                return ocm.getObjects(query);
            }
        });
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
    }
}

