/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr.jackrabbit.ocm;

import java.util.ArrayList;
import java.util.List;
import net.leadware.spring.jcr.jackrabbit.ocm.OcmMapperFactory;
import net.leadware.spring.jcr.jackrabbit.ocm.scanners.NodeEntityScanner;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.AnnotationMapperImpl;

public class AnnotationOcmMapperFactory
extends OcmMapperFactory {
    private String packages = null;
    private List<String> packagesList = null;
    private List<Class> ocmEntities = null;

    public AnnotationOcmMapperFactory() {
    }

    public AnnotationOcmMapperFactory(List<String> packagesList) {
        this.packagesList = packagesList;
    }

    public String getPackages() {
        return this.packages;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }

    public List<String> getPackagesList() {
        return this.packagesList;
    }

    public void setPackagesList(List<String> packages) {
        this.packagesList = packages;
    }

    public List<Class> getOcmEntities() {
        return this.ocmEntities;
    }

    @Override
    protected void prepareMapper() throws Exception {
        this.buildPackagesList();
        NodeEntityScanner scanner = new NodeEntityScanner(this.packagesList);
        this.ocmEntities = scanner.scan();
    }

    @Override
    protected Mapper createMapper() throws Exception {
        return new AnnotationMapperImpl(this.ocmEntities);
    }

    private void buildPackagesList() {
        String[] packagesArray;
        if (this.packages == null || this.packages.trim().isEmpty()) {
            return;
        }
        if (this.packagesList == null) {
            this.packagesList = new ArrayList<String>();
        }
        for (String packageEntry : packagesArray = this.packages.split(",")) {
            this.packagesList.add(packageEntry.trim());
        }
    }
}

