/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import net.leadware.spring.jcr.JcrAction;
import net.leadware.spring.jcr.JcrExceptionUtils;
import net.leadware.spring.jcr.JcrTemplate;
import net.leadware.spring.jcr.JcrUtils;
import net.leadware.spring.jcr.SessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class JcrTemplateImpl
implements JcrTemplate,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected SessionFactory sessionFactory;

    public JcrTemplateImpl() {
    }

    public JcrTemplateImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Object execute(JcrAction action, boolean autoSave) throws DataAccessException {
        Session session = null;
        try {
            session = this.sessionFactory.getSession();
            Object result = action.execute(session);
            if (autoSave) {
                session.save();
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw JcrExceptionUtils.translateException(e);
        }
        finally {
            try {
                if (session != null) {
                    session.logout();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Object execute(JcrAction action) throws DataAccessException {
        return this.execute(action, true);
    }

    @Override
    public Node addNode(final Node parent, final String nodePath) throws DataAccessException {
        return (Node)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return JcrUtils.getOrCreateNodeByPath(parent, nodePath, null, session);
            }
        });
    }

    @Override
    public Node addNode(final String nodePath) throws DataAccessException {
        return (Node)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return JcrUtils.getOrCreateNodeByPath(nodePath, null, session);
            }
        });
    }

    @Override
    public boolean itemExists(final String itemPath) {
        return (Boolean)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return session.itemExists(itemPath);
            }
        });
    }

    @Override
    public boolean nodeExists(final String nodePath) {
        return (Boolean)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return JcrUtils.nodeExist(nodePath, session);
            }
        });
    }

    @Override
    public Item getItem(final String path) {
        return (Item)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return JcrUtils.getItem(path, session);
            }
        });
    }

    @Override
    public Node getNode(final String path) throws DataAccessException {
        return (Node)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return JcrUtils.getNode(path, session);
            }
        });
    }

    @Override
    public List<Node> executeSQL2Query(final String query) throws DataAccessException {
        return (List)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query qry = queryManager.createQuery(query, "JCR-SQL2");
                QueryResult result = qry.execute();
                NodeIterator iterator = result.getNodes();
                ArrayList<Node> nodes = new ArrayList<Node>();
                while (iterator.hasNext()) {
                    nodes.add(iterator.nextNode());
                }
                return nodes;
            }
        });
    }

    @Override
    public void copy(final Node sourceNode, final Node destinationNode) throws DataAccessException {
        this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                session.getWorkspace().copy(sourceNode.getPath(), destinationNode.getPath());
                return null;
            }
        });
    }

    @Override
    public void move(final String sourcePath, final String destinationPath) throws DataAccessException {
        this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                session.move(sourcePath, destinationPath);
                return null;
            }
        });
    }

    @Override
    public void move(final Node sourceNode, final Node destinationNode) throws DataAccessException {
        this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                session.move(sourceNode.getPath(), destinationNode.getPath());
                return null;
            }
        });
    }

    @Override
    public String dump(final Node node) throws DataAccessException {
        return (String)this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                return JcrUtils.dump(node);
            }
        });
    }

    @Override
    public void remove(Node node) throws DataAccessException {
        try {
            this.remove(node.getPath());
        }
        catch (RepositoryException e) {
            throw JcrExceptionUtils.translateException((Exception)((Object)e));
        }
    }

    @Override
    public void remove(final String path) throws DataAccessException {
        this.execute(new JcrAction(){

            @Override
            public Object execute(Session session) throws IOException, RepositoryException {
                session.removeItem(path);
                return null;
            }
        });
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
    }
}

