/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr;

import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import net.leadware.spring.jcr.exceptions.InvalidPathException;

public class JcrUtils {
    public static boolean nodeExist(Node parent, String path) throws RepositoryException {
        try {
            parent.getNode(JcrUtils.getRelativePath(path));
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public static boolean nodeExist(String path, Session session) throws RepositoryException {
        return JcrUtils.nodeExist(session.getRootNode(), path);
    }

    public static Item getItem(String itemPath, Session session) throws RepositoryException {
        try {
            return session.getItem(JcrUtils.getAbsolutePath(itemPath));
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public static Node getNode(String nodePath, Session session) throws RepositoryException {
        try {
            return session.getNode(JcrUtils.getAbsolutePath(nodePath));
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public static String dump(Node node) throws RepositoryException {
        String endLine = "\n";
        String tabulation = "\t";
        StringBuilder builder = new StringBuilder();
        builder.append(node.getPath() + endLine);
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            builder.append(tabulation);
            builder.append(property.getPath() + " = ");
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        builder.append(",");
                    }
                    builder.append(values[i].getString());
                }
            } else {
                builder.append(property.getString());
            }
            builder.append(endLine);
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node child = nodes.nextNode();
            builder.append(endLine);
            builder.append(JcrUtils.dump(child));
        }
        return builder.toString();
    }

    public static Node getOrCreateNodeByPath(Node parent, String path, String nodeType, Session session) throws RepositoryException {
        if (path == null || path.trim().isEmpty()) {
            throw new InvalidPathException("Le chemin du noeud a creer est vide");
        }
        String relativePath = JcrUtils.getRelativePath(path);
        if (JcrUtils.nodeExist(parent, relativePath)) {
            return parent.getNode(relativePath);
        }
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        Node current = parent;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if (!current.hasNode(token)) {
                if (nodeType == null || nodeType.trim().isEmpty()) {
                    current.addNode(token);
                } else {
                    current.addNode(token, nodeType.trim());
                }
            }
            current = current.getNode(token);
        }
        return current;
    }

    public static Node getOrCreateNodeByPath(String path, String nodeType, Session session) throws RepositoryException {
        return JcrUtils.getOrCreateNodeByPath(session.getRootNode(), path, nodeType, session);
    }

    private static String getAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        return path.trim().startsWith("/") ? path.trim() : "/".concat(path.trim());
    }

    private static String getRelativePath(String path) {
        if (path == null) {
            return null;
        }
        return path.trim().startsWith("/") ? path.trim().substring(1) : path.trim();
    }

    public static void main(String[] args) {
        String chn = "/a/b/c/d";
        System.out.println("--- " + chn.substring(1));
    }
}

