/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr.jackrabbit.ocm.scanners;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Node;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class NodeEntityScanner {
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    private List<String> basePackages;

    public NodeEntityScanner() {
    }

    public NodeEntityScanner(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    public List<Class> scan() throws IOException, ClassNotFoundException {
        if (this.basePackages == null || this.basePackages.isEmpty()) {
            return null;
        }
        HashSet nodeEntities = new HashSet();
        for (String basePackage : this.basePackages) {
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage)) + "/" + "**/*.class";
            Resource[] resources = this.resourcePatternResolver.getResources(packageSearchPath);
            if (resources == null || resources.length == 0) {
                return null;
            }
            for (Resource resource : resources) {
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                if (!this.isCandidate(resource, metadataReader)) continue;
                nodeEntities.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
            }
        }
        return new ArrayList<Class>(nodeEntities);
    }

    private boolean isCandidate(Resource resource, MetadataReader metadataReader) {
        try {
            Class<?> cls;
            return resource.isReadable() && (cls = Class.forName(metadataReader.getClassMetadata().getClassName())).getAnnotation(Node.class) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

