/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr.jackrabbit.ocm;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.leadware.spring.jcr.AbstractJcrSessionFactory;
import net.leadware.spring.jcr.jackrabbit.ocm.OcmSessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.manager.ObjectContentManager;
import org.apache.jackrabbit.ocm.manager.impl.ObjectContentManagerImpl;
import org.apache.jackrabbit.ocm.mapper.Mapper;

public class JackrabbitOcmSessionFactory
extends AbstractJcrSessionFactory
implements OcmSessionFactory {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Mapper mapper;

    public JackrabbitOcmSessionFactory() {
    }

    public JackrabbitOcmSessionFactory(Repository repository, String workspaceName, Credentials credentials, Mapper mapper) {
        super(repository, workspaceName, credentials);
        this.mapper = mapper;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    protected Map<String, String> getNamespaces() {
        Map<Object, Object> namespaces = super.getNamespaces() == null ? new HashMap() : super.getNamespaces();
        namespaces.put("ocm", "http://jackrabbit.apache.org/ocm");
        return namespaces;
    }

    @Override
    public ObjectContentManager getOCM() throws RepositoryException {
        Session session = this.getSession();
        return new ObjectContentManagerImpl(session, this.mapper);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public void destroy() throws Exception {
        block3: {
            if (this.getOCM() != null) {
                try {
                    this.getOCM().logout();
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)String.format("Erreur survenue lors de la dexonnexion de la session JCR : %1$s", e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

