/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr.jackrabbit.ocm;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.leadware.spring.jcr.jackrabbit.ocm.OcmMapperFactory;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.impl.digester.DigesterMapperImpl;
import org.springframework.core.io.Resource;

public class DigesterOcmMapperFactory
extends OcmMapperFactory {
    private Set<Resource> mappings = null;
    private InputStream[] mappingsTable = null;
    private boolean validate = false;

    public DigesterOcmMapperFactory() {
    }

    public DigesterOcmMapperFactory(Set<Resource> mappings) {
        this.mappings = mappings;
    }

    public Set<Resource> getMappings() {
        return this.mappings;
    }

    public void setMappings(Set<Resource> mappings) {
        this.mappings = mappings;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    protected void prepareMapper() throws Exception {
        if (this.mappings == null) {
            this.mappings = new HashSet<Resource>();
        }
        this.mappingsTable = new InputStream[this.mappings.size()];
        int index = 0;
        for (Resource resource : this.mappings) {
            this.mappingsTable[index++] = resource.getInputStream();
        }
    }

    @Override
    protected Mapper createMapper() throws Exception {
        return new DigesterMapperImpl(this.mappingsTable, this.validate);
    }
}

