/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr.jackrabbit;

import java.io.File;
import javax.jcr.Repository;
import net.leadware.spring.jcr.JcrRepositoryFactory;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class JackrabbitRepositoryFactory
extends JcrRepositoryFactory {
    private static final String DEFAULT_CONF_FILE = "repository.xml";
    private static final String DEFAULT_REP_DIR = ".";
    private Resource homeDir;
    private RepositoryConfig repositoryConfig;

    public Resource getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(Resource homeDir) {
        this.homeDir = homeDir;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }

    @Override
    protected Repository createRepository() throws Exception {
        return RepositoryImpl.create((RepositoryConfig)this.repositoryConfig);
    }

    @Override
    protected void resolveConfigurationResource() throws Exception {
        if (this.repositoryConfig != null) {
            return;
        }
        if (this.configuration == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Aucun fichier de configuration n'a ete specifie : le fichier par defaut sera utilise - repository.xml");
            }
            this.configuration = new ClassPathResource(DEFAULT_CONF_FILE);
        }
        if (this.homeDir == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Aucun repertoire de travail n'a ete specifie : le repertoire par defaut sera utilise - .");
            }
            this.homeDir = new FileSystemResource(DEFAULT_REP_DIR);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construction de la configuration de depot : homeDir = " + this.homeDir + ", configuration = " + this.configuration));
        }
        this.repositoryConfig = this.configuration.exists() ? RepositoryConfig.create((InputSource)new InputSource(this.configuration.getInputStream()), (String)this.homeDir.getFile().getAbsolutePath()) : RepositoryConfig.install((File)this.homeDir.getFile());
    }

    @Override
    public void destroy() throws Exception {
        if (this.repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this.repository).shutdown();
        }
    }
}

