/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.spring.jcr;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import net.leadware.spring.jcr.exceptions.JcrSystemException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;

public class JcrExceptionUtils {
    public static DataAccessException translateException(Exception exception) {
        if (exception instanceof AccessDeniedException) {
            return new DataRetrievalFailureException("selfpaas.tools.jcr.accessdenied", (Throwable)exception);
        }
        if (exception instanceof ConstraintViolationException) {
            return new DataIntegrityViolationException("selfpaas.tools.jcr.constraint.violation", (Throwable)exception);
        }
        if (exception instanceof InvalidItemStateException) {
            return new ConcurrencyFailureException("selfpaas.tools.jcr.invalid.state", (Throwable)exception);
        }
        if (exception instanceof InvalidQueryException) {
            return new DataRetrievalFailureException("selfpaas.tools.jcr.invalid.query", (Throwable)exception);
        }
        if (exception instanceof InvalidSerializedDataException) {
            return new DataRetrievalFailureException("selfpaas.tools.jcr.invalid.serializable.data", (Throwable)exception);
        }
        if (exception instanceof ItemExistsException) {
            return new DataIntegrityViolationException("selfpaas.tools.jcr.item.already.exists", (Throwable)exception);
        }
        if (exception instanceof ItemNotFoundException) {
            return new DataRetrievalFailureException("selfpaas.tools.jcr.item.not.found", (Throwable)exception);
        }
        if (exception instanceof LoginException) {
            return new DataAccessResourceFailureException("selfpaas.tools.jcr.login.invalid.data", (Throwable)exception);
        }
        if (exception instanceof LockException) {
            return new ConcurrencyFailureException("selfpaas.tools.jcr.locked.data", (Throwable)exception);
        }
        if (exception instanceof MergeException) {
            return new DataIntegrityViolationException("selfpaas.tools.jcr.merge.failed", (Throwable)exception);
        }
        if (exception instanceof NoSuchWorkspaceException) {
            return new DataAccessResourceFailureException("selfpaas.tools.jcr.workspace.not.found", (Throwable)exception);
        }
        if (exception instanceof PathNotFoundException) {
            return new DataRetrievalFailureException("selfpaas.tools.jcr.item.not.found", (Throwable)exception);
        }
        if (exception instanceof ReferentialIntegrityException) {
            return new DataIntegrityViolationException("selfpaas.tools.jcr.referential.constraint.violation", (Throwable)exception);
        }
        return new JcrSystemException(exception);
    }
}

